package admin;

import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

import javax.naming.NamingException;

import serveur.ServeurInfos;
import serveur.ServeurRemote;
import serveur.exceptions.ServeurException;
import tools.Loggeur;

public class Admin extends UnicastRemoteObject implements AdminRemote {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private AdminInfos adminInfos;
	private ServeurRemote serveur;	
	
	private Vector<AdminActionListener> lstAal;
	
	/**
	 * Constructeur qui ne comprend que le premier serveur
	 * @param idserveur Le nom du serveur
	 * @throws RemoteException
	 */
	public Admin(AdminInfos adminInfos) throws RemoteException {
		super();
		this.adminInfos = adminInfos;
		this.serveur = null;
		lstAal = new Vector<AdminActionListener>();
	}
	
	public void addAdminActionListener(AdminActionListener aal){
		if(!lstAal.contains(aal)){
			lstAal.add(aal);
		}
	}
	
	public AdminInfos getAdminInfos(){
		return adminInfos;
	}
	
	public void init() throws RemoteException{
		Loggeur.writeLog("Admin", "Initialisation");
		Loggeur.writeLog("Admin", "Bind de l'admin " + adminInfos);
		Registry rServeur = LocateRegistry.getRegistry("localhost", adminInfos.port);
		rServeur.rebind(adminInfos.nom, this);
		Loggeur.writeLog("Admin", "Admin " + adminInfos.nom + " pret");
	}
	
	public void destroy() throws RemoteException, NotBoundException {
		Loggeur.writeLog("Admin", "Fermeture de la connexion RMI");
		UnicastRemoteObject.unexportObject(this, true);
		Loggeur.writeLog("Admin", "Unbind de l'admin");
		Registry rServeur = LocateRegistry.getRegistry("localhost", adminInfos.port);
		rServeur.unbind(adminInfos.nom);
	}
	
	public void setServeur(ServeurInfos serveurInfos) throws RemoteException, MalformedURLException, NotBoundException, NamingException {
		Loggeur.writeLog("Admin", "Connexion au serveur " + serveurInfos);
		Registry rServeur = LocateRegistry.getRegistry(serveurInfos.hote, serveurInfos.port);
		this.serveur = (ServeurRemote)rServeur.lookup(serveurInfos.nom);
		Loggeur.writeLog("Admin", "Connexion au serveur OK");
	}
	
	public void demarrerTerminaison() throws RemoteException, ServeurException {
		Loggeur.writeLog("Admin", "Debut de la terminaison de la plateforme");
		this.serveur.demarrerTerminaison(adminInfos);
	}
	
	public void alerteFinTerminaison() throws RemoteException {
		for(AdminActionListener aal : lstAal){
			aal.onFinTerminaison();
		}
	}

}
