package serveur;

import java.io.Serializable;

import serveur.exceptions.ServeurException;

import client.ClientInfos;
import decoupage.Morceau;
import filtre.EnumTypeFiltre;

public class JetonTraitement extends Jeton implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public final ClientInfos client;
	public final Morceau morceau;
	public final EnumTypeFiltre filtre;
	
	public JetonTraitement(ServeurInfos initiateur, ClientInfos client, Morceau morceau, EnumTypeFiltre filtre){
		super(initiateur);
		this.client = client;
		this.morceau = morceau;
		this.filtre = filtre;
	}
	
	public ActionTraitementJeton traiterJeton(Serveur serveur) throws ServeurException {
		return serveur.traiterJeton(this);
	}
	
}
