import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class TestConcurrentLib {

	public static void main(String[] args) throws Exception {

		// On cre un nouveau Thread qui utilisera des String :
		MyTask<String> task = new MyTask<String>() {
			@Override
			public void received(String data) {
				System.out.println("Received : [" + data + "]");
			}
		};
		task.start(); // on dmarre le thread

		for (int i = 0; i < 20; i++) {
			task.send("Hello !", "World !");
		}
		
		System.out.println("Attente");
		Thread.sleep(2000);

		task.send("Bye Bye");
		task.interrupt();
	}
}

abstract class MyTask<E> extends Thread {

	/** Queue qui stockera les donnes avant le traitement */
	private final BlockingQueue<E> queue = new LinkedBlockingQueue<E>();

	/**
	 * "Envoi" les donnes au thread. En fait lles donnes sont pass  la Queue
	 * qui sera ensuite lu par le thread
	 * 
	 * @param str
	 */
	public final void send(E... args) {
		// On ajoute tout les lments un  un :
		for (E data : args) {
			this.queue.offer(data);
		}
	}

	/**
	 * Mthode qui traitera les donnes reus.
	 * 
	 * @param data
	 */
	public abstract void received(E data);

	/**
	 * Traitement du thread On rcupre les lments de la queue et on les
	 * traite
	 */
	public void run() {

		try {
			E current;
			// take() permet de rcuprer le premier element de la queue
			// en bloquant le thread courant tant que la liste est vide...
			while (!isInterrupted() && (current = this.queue.take()) != null) {

				// On appelle la mthode qui traitera les donnes :
				received(current);

			}
		} catch (InterruptedException e) { /* condition de fin */
		}
		System.out.println("FIN DU THREAD");
	}
}
