package projet.rmi.serveur;

/*************************************************************************
 *  Compilation:  javac Fibonacci.java
 *  Execution:    java Fibonacci N
 *
 *  Computes and prints the first N Fibonacci numbers.
 *
 *  WARNING:  this program is spectacularly inefficient and is meant
 *            to illustrate a performance bug, e.g., set N = 45.
 *
 *
 *   % java Fibonacci 7
 *   1: 1
 *   2: 1
 *   3: 2
 *   4: 3
 *   5: 5
 *   6: 8
 *   7: 13
 *
 *   Remarks
 *   -------
 *    - The 93rd Fibonacci number would overflow a long, but this
 *      will take so long to compute with this function that we
 *      don't bother to check for overflow.
 *
 *************************************************************************/

import java.text.SimpleDateFormat;
import java.util.Date;

public class FibonacciThread extends Thread {
	SimpleDateFormat sdf = new SimpleDateFormat("mm:ss,SSS");
	int n;

	public FibonacciThread(int n, String name) {
		super(name);
		this.n = n;
	}

	public static long fib(int n) {
		if (n <= 1)
			return n;
		else {
			long res = fib(n - 1) + fib(n - 2);
			return res;
		}
	}

	public void run() {
		Date toutDebut = new Date();
		while (n < 45) {
			Date debut = new Date();
			fib(n);
			Date duree = new Date(new Date().getTime() - debut.getTime());
			System.out.println(getName() + ";fib(" + this.n + ");"
					+ sdf.format(duree)+";");
			this.n++;
		}
		Date duree = new Date(new Date().getTime() - toutDebut.getTime());
		System.out.println(getName() + ";Total;"
				+ sdf.format(duree)+";");
	}

}
