#!/bin/bash

if test $# -ne 4
then
  echo "USAGE : $0 min max nb_time incr nb_threads"
  echo "        min : n minimum for fibo(n)"
  echo "        max : n maximun for fibo(n)"
  echo "        nb_time : number of time"
  echo "        incr : incrementation of n"
  exit -1
fi

echo -e "n_fibo;nb_threads;used_library;exec_time" > result.csv

#c_impl="c_nothread c_openmp c_pthreads c_fork"
#java_impl="JavaNoThread JavaThread"
csharp_impl="CSharpNoThread CSharpThread"

for dir in $c_impl
do
  (cd $dir && make clean > /dev/null)
  (cd $dir && make > /dev/null)
done

for dir in $java_impl
do
  (cd $dir && make clean > /dev/null)
  (cd $dir && make > /dev/null)
done

for dir in $csharp_impl
do
  (cd $dir && make clean > /dev/null)
  (cd $dir && make > /dev/null)
done

nth="1 2 4"
#nth="1 2"

for nb_threads in $nth
do
  for ((j=$1;j<=$2;j+=$4))
  do
    echo "do $j with $nb_threads threads"
    for dir in $c_impl
    do
      for ((i=1;i<=$3;i+=1))
      do
        ./$dir/fibonacci_$dir $j $nb_threads >> result.csv
      done
    done
    for dir in $java_impl
    do
      for ((i=1;i<=$3;i+=1))
      do    
        (cd $dir && java Fibonacci$dir $j $nb_threads) >> result.csv
      done
    done
    for dir in $csharp_impl
    do
      for ((i=1;i<=$3;i+=1))
      do    
        mono $dir/Fibonacci$dir.exe $j $nb_threads >> result.csv
      done
    done
  done
done
