#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <pthread.h>

#include <sys/time.h>

struct thread {
  int num;
  int m_size;
  int *cur_lig;
  int **m1;
  int **m2;
  int **m3;
  pthread_t pthread;
};
typedef struct thread thread;

static pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

void *task (void *p_data)
{
  thread* data = (thread*)p_data;
  int i, j, k;

  do{
    pthread_mutex_lock (&mutex);
    *(data->cur_lig) = *(data->cur_lig)+1;
    i=*(data->cur_lig);
    pthread_mutex_unlock (&mutex);
    
    if(i<data->m_size){
      for(j=0;j<data->m_size;j++){
	for(k=0;k<data->m_size;k++){
	  data->m3[i][j] += data->m1[i][k] * data->m2[k][j];
	}
      }
    }
  }while(i<data->m_size);
  
  return NULL;
}

int main(int argc, char **argv) {
  
  struct timeval tv_start, tv_finish;
  double realtime;
  
  int m_size;
  int **matrix1;
  int **matrix2;
  int **matrix3;
  
  int nb_threads;

  int i, j;
  int cur_lig;

  thread *tab_th;
  int th;

  if(argc < 3){
    printf("USAGE : %s m_size nb_threads [-v]\n", argv[0]);
    printf("        m_size : size of the matrice\n");
    printf("        nb_threads : number of threads\n");
    printf("        -v : verbose\n");
    return -1;
  }
  
  /* Depart du chrono */
  gettimeofday(&tv_start, 0);

  m_size=atoi(argv[1]);
  nb_threads=atoi(argv[2]);

  /* Creation des matrices */
  matrix1 = (int**)malloc(m_size*sizeof(int*));
  matrix2 = (int**)malloc(m_size*sizeof(int*));
  matrix3 = (int**)malloc(m_size*sizeof(int*));
  for(i=0;i<m_size;i++){
    matrix1[i] = (int*)malloc(m_size*sizeof(int));
    matrix2[i] = (int*)malloc(m_size*sizeof(int));
    matrix3[i] = (int*)malloc(m_size*sizeof(int));
    for(j=0;j<m_size;j++){
      matrix1[i][j] = i+j+1;
      matrix2[i][j] = i+j+1;
      matrix3[i][j] = 0;
    }
  }  

  /* Creation des threads */
  tab_th = (thread*) malloc(nb_threads * sizeof(thread));
  cur_lig=-1;
  for(th=0;th<nb_threads;th++){
    tab_th[th].num=th;
    tab_th[th].m_size=m_size;
    tab_th[th].cur_lig=&cur_lig;
    tab_th[th].m1=matrix1;
    tab_th[th].m2=matrix2;
    tab_th[th].m3=matrix3;
    pthread_create (&((tab_th[th]).pthread), NULL, 
		    task, (void*)(tab_th+th));
  }
  for(th=0;th<nb_threads;th++){
    pthread_join (tab_th[th].pthread, NULL);
  }
  
  free(tab_th);
  
  /* Affichage du resultat */
  if(argc == 4){
      for(i=0;i<m_size;i++){
	printf("[");
	for(j=0;j<m_size;j++){
	  printf("[%d]", matrix3[i][j]);
	}
	printf("]\n");
      }
  }

  /* Liberation des matrices */
  for(i=0;i<m_size;i++){
    free(matrix1[i]);
    free(matrix2[i]);
    free(matrix3[i]);
  } 
  free(matrix1);
  free(matrix2);
  free(matrix3);

  /* Fin du chrono */
  gettimeofday(&tv_finish, 0);
  
  /* Affichage du resultat */
  realtime = (double)(tv_finish.tv_sec-tv_start.tv_sec) +
    ((double)(tv_finish.tv_usec-tv_start.tv_usec))*1e-6;
  printf("%d;%d;c_pthreads;%f\n", m_size, nb_threads, realtime);
  
  return 0;
}
