#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <sys/time.h>

int main(int argc, char **argv) {
  
  struct timeval tv_start, tv_finish;
  double realtime;
  
  int m_size;
  int **matrix1;
  int **matrix2;
  int **matrix3;

  int i, j, k;

  if(argc < 2){
    printf("USAGE : %s m_size [anything -v]\n", argv[0]);
    printf("        m_size : size of the matrice\n");
    printf("        anything : just pass anything\n");
    printf("        -v : show the result matrice\n");
    return -1;
  }
  
  /* Depart du chrono */
  gettimeofday(&tv_start, 0);

  m_size=atoi(argv[1]);

  /* Creation des matrices */
  matrix1 = (int**)malloc(m_size*sizeof(int*));
  matrix2 = (int**)malloc(m_size*sizeof(int*));
  matrix3 = (int**)malloc(m_size*sizeof(int*));
  for(i=0;i<m_size;i++){
    matrix1[i] = (int*)malloc(m_size*sizeof(int));
    matrix2[i] = (int*)malloc(m_size*sizeof(int));
    matrix3[i] = (int*)malloc(m_size*sizeof(int));
    for(j=0;j<m_size;j++){
      matrix1[i][j] = i+j+1;
      matrix2[i][j] = i+j+1;
      matrix3[i][j] = 0;
    }
  }  
  
  /* Produit matriciel */
  for(i=0;i<m_size;i++){
    for(j=0;j<m_size;j++){
      for(k=0;k<m_size;k++){
	matrix3[i][j] += matrix1[i][k] * matrix2[k][j];
      }
    }
  }

  /* Affichage du resultat */
  if(argc == 4){
      for(i=0;i<m_size;i++){
	printf("[");
	for(j=0;j<m_size;j++){
	  printf("[%d]", matrix3[i][j]);
	}
	printf("]\n");
      }
  }

  /* Liberation des matrices */
  for(i=0;i<m_size;i++){
    free(matrix1[i]);
    free(matrix2[i]);
    free(matrix3[i]);
  } 
  free(matrix1);
  free(matrix2);
  free(matrix3);
  
  /* Fin du chrono */
  gettimeofday(&tv_finish, 0);
  
  /* Affichage du resultat */
  realtime = (double)(tv_finish.tv_sec-tv_start.tv_sec) +
    ((double)(tv_finish.tv_usec-tv_start.tv_usec))*1e-6;
  printf("%d;%d;c_nothread;%f\n", m_size, 1, realtime);
  
  return 0;
}
