package projet.matrice;

import java.util.Date;

/**
 * Définition de la classe Matrice (Matrix) dans lequel nous trouvons beaucoup
 * de méthodes, d'opérations sur les matrices Remarque : Cette classe est
 * seulement un outils dans le but d'effectuer des calculs sur les graphes. Ceci
 * n'est pas une classe compléte pour la manipulation de matrice.
 * 
 * @author ASLAN Hikmet
 * @version 1.1
 */

public class Matrice {
	private long[][] coeff = null;

	/**
	 * Constructeur Matrice
	 * 
	 * @param int i - ligne int j - colonne
	 */
	public Matrice(int i, int j) {
		this.setLength(i, j);
	}

	public Matrice() {
		this(0, 0);
	}

	/**
	 * Constructeur
	 * 
	 * @param mat
	 */
	public Matrice(long[][] mat) {
		this.coeff = mat;
	}

	/**
	 * Définit une matrice de type long[][]
	 * 
	 * @param mat
	 */
	public void setMatrice(long[][] mat) {
		this.coeff = mat;
	}

	/**
	 * définit une valeur Ã la position i et j
	 * 
	 * @param i Ligne
	 * @param j Colonne
	 * @param value
	 */
	public void setValue(int i, int j, long value) {
		this.coeff[i][j] = value;
	}

	/**
	 * on définit la taille de la mtrice
	 * 
	 * @param i
	 * @param j
	 */
	public void setLength(int i, int j) {
		this.coeff = new long[i][j];
	}

	/**
	 * retourne la matrice sous forme du type long[][]
	 * 
	 * @return
	 */
	public long[][] getMatrice() {
		return this.coeff;
	}

	/**
	 * retourne le nombre de ligne
	 * 
	 * @return
	 */
	public int getRows() {
		return this.coeff.length;
	}

	/**
	 * retourne le nombre de colonne
	 * 
	 * @return
	 */
	public int getColumns() {
		return this.coeff[0].length;
	}

	/**
	 * retourne la valeur Ã la position i et j
	 * 
	 * @param i
	 * @param j
	 * @return
	 */
	public long getValue(int i, int j) {
		return this.coeff[i][j];
	}

	/**
	 * Multiplication d'une matrice par une autre
	 * 
	 * @param matrice
	 * @return
	 */
	public Matrice multiply(final Matrice matrice) {
		Matrice a = new Matrice(this.getRows(), this.getColumns());
		int k, i;

		for (k = 0; k < matrice.getColumns(); k++) {
			for (i = 0; i < this.getRows(); i++) {
				multiplyTmp(matrice, k, i, a);
			}
		}
		return a;
	}

	private void multiplyTmp(Matrice matrice, int k, int i, Matrice res) {
		long value = 0;
		for (int j = 0; j < matrice.getColumns(); j++) {
			value += this.getValue(i, j) * matrice.getValue(j, k);
		}
		res.setValue(i, k, value);
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		String out = "";
		for (int i = 0; i < this.getRows(); i++) {
			for (int j = 0; j < this.getColumns(); j++) {
				out += this.coeff[i][j] + "\t ";
			}
			out += "\n";
		}
		return out;
	}

	/**
	 * definit si deux matrices sont équivalentes
	 * 
	 * @param matrice
	 * @return
	 */
	public boolean equals(Matrice matrice) {
		for (int i = 0; i < this.getRows(); i++) {
			for (int j = 0; j < this.getColumns(); j++) {
				if (this.getValue(i, j) != matrice.getValue(i, j)) {
					return false;
				}
			}
		}
		return true;
	}

	/**
	 * Main
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		int n;
		int nbThread;

		if (args.length < 2) {
			System.out.println("USAGE : n_fibo nb_threads\n"
				+ "        n_fibo : an integer\n"
				+ "        n_threads : an integer\n");
			return;
		}

		n = Integer.parseInt(args[0]);
		nbThread = Integer.parseInt(args[1]);

		// matrice d'adjacence d'un graphe
		Matrice a = new Matrice(n, n);
		int v = 0;
		for (int i = 0; i < n; i++) {
			v = i;
			for (int j = 0; j < n; j++) {
				a.setValue(i, j, v);
				v++;
			}
		}

		// Début du chrono
		Date debut = new Date();

		a.multiply(a);

		// Fin du chrono
		Date duree = new Date(new Date().getTime() - debut.getTime());
		double realtime = (duree.getTime() / 1000.0);
		System.out.println(n + ";" + nbThread + ";JavaNoThread;" + realtime);

	}
}