package projet.fibonacci;

/*************************************************************************
 *  Compilation:  javac Fibonacci.java
 *  Execution:    java Fibonacci N
 *
 *  Computes and prints the first N Fibonacci numbers.
 *
 *  WARNING:  this program is spectacularly inefficient and is meant
 *            to illustrate a performance bug, e.g., set N = 45.
 *
 *
 *   % java Fibonacci 7
 *   1: 1
 *   2: 1
 *   3: 2
 *   4: 3
 *   5: 5
 *   6: 8
 *   7: 13
 *
 *   Remarks
 *   -------
 *    - The 93rd Fibonacci number would overflow a long, but this
 *      will take so long to compute with this function that we
 *      don't bother to check for overflow.
 *
 *************************************************************************/


public class FibonacciJavaThread extends Thread {
	int n;

	public FibonacciJavaThread(int n, String name) {
		super(name);
		this.n = n;
	}

	public static long fib(int n) {
		if (n <= 1)
			return n;
		else {
			long res = fib(n - 1) + fib(n - 2);
			return res;
		}
	}

	public void run() {
		fib(n);
	}

}
