#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <pthread.h>

#include <sys/time.h>

int
fibo(int n)
{
  if(n <= 1){
    /* cas de base */
    return n; /* si n=0 return 0 si n=1 return 1 */
  } else {
    return fibo(n - 1) + fibo(n - 2); 
  }
}

void *task (void *p_data)
{
  int n_fibo = (int)p_data;
  fibo(n_fibo);
  /*printf("Th : %d\n", td->thread);*/
  return NULL;
}

int main(int argc, char **argv) {
  
  struct timeval tv_start, tv_finish;
  double realtime;

  int n_fibo;
  int nb_threads;

  int i;

  pthread_t *tab_th;
  
  if(argc < 3){
    printf("USAGE : %s n_fibo nb_threads\n        n_fibo : an integer\n        n_threads : an integer\n", argv[0]);
    return -1;
  }
  
  /* Depart du chrono */
  gettimeofday(&tv_start, 0);
  
  n_fibo=atoi(argv[1]);
  nb_threads=atoi(argv[2]);
  
  tab_th = (pthread_t*) malloc(nb_threads * sizeof(pthread_t));
  for(i=0;i<=nb_threads;i++){
    pthread_create (&tab_th[i], NULL, task, (void*)n_fibo);
  }
  
  for(i=0;i<=nb_threads;i++){
    pthread_join (tab_th[i], NULL);
  }
  
  free(tab_th);
  
  /* Fin du chrono */
  gettimeofday(&tv_finish, 0);
  
  /* Affichage du resultat */
  realtime = (double)(tv_finish.tv_sec-tv_start.tv_sec) +
    ((double)(tv_finish.tv_usec-tv_start.tv_usec))*1e-6;
  printf("%d;%d;c_pthreads;%f\n", n_fibo, nb_threads, realtime);
  
  return 0;
}
