/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import jsr166y.forkjoin.AsyncAction;

public abstract class LinkedAsyncAction
extends AsyncAction {
    private LinkedAsyncAction parent;

    protected LinkedAsyncAction() {
    }

    protected LinkedAsyncAction(LinkedAsyncAction parent) {
        this.parent = parent;
        if (parent != null) {
            parent.incrementStatus();
        }
    }

    protected LinkedAsyncAction(LinkedAsyncAction parent, boolean register) {
        this.parent = parent;
        if (parent != null && register) {
            parent.incrementStatus();
        }
    }

    protected LinkedAsyncAction(LinkedAsyncAction parent, boolean register, int pending) {
        if (pending < 0) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.status = pending;
        if (parent != null && register) {
            parent.incrementStatus();
        }
    }

    protected void onCompletion() {
    }

    protected boolean onException() {
        return true;
    }

    @Override
    public final void finish() {
        LinkedAsyncAction a = this;
        while (a != null && !a.isDone()) {
            int c = a.status;
            if (c <= 0) {
                try {
                    a.onCompletion();
                }
                catch (Throwable rex) {
                    a.finishExceptionally(rex);
                    return;
                }
                a.setDone();
                a = a.parent;
                continue;
            }
            if (!a.casStatus(c, c - 1)) continue;
            return;
        }
    }

    @Override
    public final void finishExceptionally(Throwable ex) {
        if (!(ex instanceof RuntimeException) && !(ex instanceof Error)) {
            throw new IllegalArgumentException(ex);
        }
        this.doFinishExceptionally(ex);
    }

    private void doFinishExceptionally(Throwable ex) {
        LinkedAsyncAction a = this;
        while (a.status != -3) {
            a.setDoneExceptionally(ex);
            boolean up = a.onException();
            a = a.parent;
            if (a == null) break;
            if (up) continue;
            a.finish();
            break;
        }
    }

    public final LinkedAsyncAction getParent() {
        return this.parent;
    }

    public final int getPendingSubtaskCount() {
        return this.status;
    }

    @Override
    public void reinitialize() {
        super.reinitialize();
    }

    public void reinitialize(int pending) {
        if (pending < 0) {
            throw new IllegalArgumentException();
        }
        super.reinitialize();
        this.status = pending;
    }

    public void reinitialize(LinkedAsyncAction parent, boolean register) {
        super.reinitialize();
        this.parent = parent;
        if (parent != null && register) {
            parent.incrementStatus();
        }
    }

    public void reinitialize(LinkedAsyncAction parent, boolean register, int pending) {
        if (pending < 0) {
            throw new IllegalArgumentException();
        }
        super.reinitialize();
        this.status = pending;
        this.parent = parent;
        if (parent != null && register) {
            parent.incrementStatus();
        }
    }

    @Override
    final boolean exec() {
        if (this.status >= 0) {
            try {
                this.compute();
            }
            catch (Throwable rex) {
                this.doFinishExceptionally(rex);
            }
        }
        return false;
    }
}

