/*
 ****************************************************************
 * Programme : basket.cpp
 *
 * Ecrit par : Beuque Eric
 *
 * Resume : Jeu de mini-basket avec obstacle gerant les 
 *          performances du joueur 
 *
 * Date : 25/04/2005
 *
 ***************************************************************
 */

#include<iostream>
#include<string>
#include<cmath>
extern "C"
{
#include "graphlib.h"
}
#include<unistd.h>
#include<sstream>

// Definition des structures
typedef struct objet{
  int hauteur;   // hauteur de l'objet
  int largeur;   // largeur de l'objet
  int placement; // abscisse de l'objet
};

typedef struct Balle{
  int x; // abscisse de la balle
  int y; // ordonnee de la balle
};

int ClicSouris(int posX, int posY, int &puissance, float &angle);
/* Modifie l'interface en fonction de la position du clic de souris
   et renvoie un entier correspondant au statut du jeu */
int aleat(int min, int max);
/* Renvoie un entier aleatoire entre min et max */
bool collision(objet panier, objet obstacle, Balle balle);
/* Renvoie vrai si la balle rentre en collision avec un objet */
bool dansPanier(objet panier, Balle balle);
/* Renvoie vrai si la balle est dans le panier */
void dessineObjet(struct objet obstacle, struct objet panier);
/* Dessine l'obstacle et le panier sur l'interface */
void dessineCanon(float angle);
/* Dessine le canon indiquant l'angle de tir */
void dessineBalle(struct Balle balle, int couleur);
/* Dessine la balle en fonction de ses coordonnees */ 
void dessineJauge(int puissance);
/* Dessine la jauge en fonction de la puissance */
void dessineMenu(int tirsReussi, int tirs);
/* Dessine le menu en fonction du score du joueur */


using namespace std;

int main(int argc, char **argv)
{
  int sourisX;          // abscisse de la souris 
  int sourisY;          // ordonnee de la souris
  int statutJeu=0;      // statut du jeu
  int puissance=50;     // puissance su tir
  float angle=M_PI/4;   // angle du tir en radian
  int nbTirReussi=0;    // nombre de tir reussi par le joueur
  int nbTir=0;          // nombre de tir fait par le joueur
  bool initObjet=true;  // vrai si on doit reinitialiser le panier et l'obtacle
  objet obstacle;       // informations de l'obstacle
  objet panier;         // informations du panier
  Balle balle;          // informations de la balle
  float t=0.1;          // instant de la position de la balle 

  /* Initialisation la fenetre */
  ouvrirFenetreTailleTitre(800,600,"MINI-BASKET");
  initPalette(NULL,256);

  /* Tant que le statut du jeu n'indique pas qu'il faut quitter */
  while(statutJeu!=-1){
    viderFenetre();
    srand(time(NULL));

    /* Si il faut reinitialiser l'obstacle et le panier */
    if(initObjet){
      /* Intialisation du panier et de l'obstacle
	 calcul aleatoire des coordonnes des deux objets */
      obstacle.hauteur=aleat(100,400);
      obstacle.largeur=aleat(10,300);
      obstacle.placement=aleat(250,550-obstacle.largeur);
      panier.hauteur=aleat(20,100);
      panier.largeur=aleat(20,50);
      panier.placement=aleat(600,789-panier.largeur);
    }

    /* Dessin de l'interface */
    dessineObjet(obstacle,panier);
    dessineMenu(nbTirReussi,nbTir);
    dessineCanon(angle);      
    dessineJauge(puissance);
    
    /* Dessin de la balle */
    balle.x=(int)(150*cos(angle));
    balle.y=(int)(600-150*sin(angle));
    dessineBalle(balle,6);
    
    /* Tant que le statut n'indique aucune action */ 
    while(statutJeu==0){
      /* Recuperation de la position de la souris */
      positionSouris((int*)&sourisX,(int*)&sourisY);
      rafraichirFenetre();
      
      /* Modification de l'interface en fonction du clic */
      statutJeu=ClicSouris(sourisX,sourisY,puissance,angle);

      /* Dessin de la balle en fonction de l'angle de tir */
      dessineBalle(balle,1);
      balle.x=(int)(150*cos(angle));
      balle.y=(int)(600-150*sin(angle));
      dessineBalle(balle,6);
    }

    /* Si le statut du jeu indique le lancement */
    if(statutJeu==1){   
      t=0.1;
      
      /* Tant que la balle n'a subit aucune collision */
      while(collision(panier,obstacle,balle)==false){
	/* Dessin de la balle : on efface l'ancienne balle, on 
	   calcule ses nouvelles coordonnees, puis on trace la
	   balle */
	dessineBalle(balle,1);
	balle.x=(int)(puissance*cos(angle)*t)+(int)(150*cos(angle));
	balle.y=(int)(-0.5*9.81*t*t+puissance*sin(angle)*t)*-1
	  +(int)(600-150*sin(angle));
	dessineBalle(balle,6);

	/* Temporisation de la trajectoire */
	t=t+0.01;
	usleep(1000);
	
	/* Si la balle traverse un element de l'interface on le redessine*/ 
	if(balle.y<40){
	  dessineMenu(nbTirReussi,nbTir);
	}
	if(balle.y<260 && balle.x<60){
	  dessineJauge(puissance);
	}	
	if(balle.y>450 && balle.x<150){
	  dessineCanon(angle);
	}
      }
      
      /* Augmentation du score si tir reussi */
      nbTir=nbTir+1;

      /* Ecriture d'un message en fonction de la reussite du joueur */
      modifierCouleur(2);
      if(dansPanier(panier,balle)){
	nbTirReussi=nbTirReussi+1;      
	ecrireSurImpression(300,150,"Bien jou !");
      }else{
	ecrireSurImpression(300,150,"Perdu dommage !");
      }
      ecrireSurImpression(300,170,"Cliquez pour recommencer...");
      
      /* Modification du statut de jeu et indication qu'il faut reinitialiser
	 l'obstacle et le panier */
      statutJeu=0;
      initObjet=true;
      attendreClic();
    }

    /* Si le statut du jeu indique qu'il faut quitter */
    if(statutJeu==-1){
      /* On trace un fenetre pour demander confirmation au joueur */
      modifierCouleur(256);
      tracerRectangle(300,100,500,200);      
      ecrireSurImpression(310,125,"Voulez-vous vraiment quitter ?");      
      ecrireSurImpression(340,167,"OUI");      
      ecrireSurImpression(440,167,"NON");
      tracerRectangle(320,150,380,175);
      tracerRectangle(420,150,480,175);
      
      /* Tant que le joueur clique ailleurs que sur les zones de reponses,
	 on recuperation de la position de la souris */
      do{
	positionSouris((int*)&sourisX,(int*)&sourisY);
      }while(!(((sourisX>320 && sourisX<380) || (sourisX>420 && sourisX<480))
	      && sourisY>150 && sourisY<175));
      /* Si le joueur indique qu'il faut quitter le jeu */
      if(sourisX<380){
	/* On indique qu'il faut quitter le jeu */
	statutJeu=-1;
      }else{
	/* On reprned le jeu dans le meme etat */
	statutJeu=0;
	initObjet=false;
      }
    }
  }
  fermerFenetre();
}

/*
 * Fonction    : ClicSouris
 *
 * Parametres  : int posX      (abscisse de la souris)
 *               int posY      (coordonnee de la souris)
 *               int puissance (puissance du tir)
 *               int angle     (angle du tir)
 *
 * Retour      : entier
 *
 * Description : Modifie l'interface en fonction de la position du 
 *               clic de souris et renvoie un entier correspondant au 
 *               statut du jeu : 1 = declenchement du tir
 *                               0 = aucune action
 *                              -1 = quitter le jeu
 *
 */
int ClicSouris(int posX, int posY, int &puissance, float &angle){
  float nouvAngle; // nouvel angle calculer

  /* Si le joueur clic sur quitter, alors on retourne -1 */
  if(posX>=0 && posX<80 && posY>=0 && posY<30){
    return(-1);
  }

  /* Si le joueur clique sur la jauge, on recalcule la puissance et on 
     retourne 0 */
  if(posX>20 && posX<50 && posY>=50 && posY<250){
    puissance=50+(int)(50*((250-posY)/200.0));
    dessineJauge(puissance);
    return(0);
  }else{
    /* Si le joueur clique dans la zone du canon, on recalcule le nouvel 
       angle puis on retourne 0 */ 
    if(sqrt((float)(posX)*(posX)+(float)(posY-600)*(posY-600))>100 &&
       sqrt((float)(posX)*(posX)+(float)(posY-600)*(posY-600))<120){
      nouvAngle=atan((float)(600-posY)/posX);
      /* Si l'anqle est compris dans [5,85], alors on le conserve et 
	 redessine le canon */
      if(nouvAngle>5*M_PI/180 && nouvAngle<85*M_PI/180){
	angle=nouvAngle;
	dessineCanon(angle);
      }
      return(0);
    }else{
      /* Si le joueur clique sur le bouton de lancement, on retourne 0 */
      if(sqrt((float)(posX-35)*(posX-35)+(float)(posY-565)*(posY-565))<5){
	return(1);
      }else{
	return(0);
      }
    }
  }
}

/*
 * Fonction    : aleat
 *
 * Parametres  : int min (valeur minimal a generer)
 *               int max (valeur maximal a generer)
 *
 * Retour      : entier
 *
 * Description : renvoi un nombre au hasard compris entre 'min' et 'max'
 *
 */
int aleat(int min, int max)
{
  return((int)(min+(max-min)*((double)rand()/RAND_MAX)));
}

/*
 * Fonction    : dansPanier
 *
 * Parametres  : objet panier (coordonnees du panier)
 *               Balle balle  (coordonnees de la balle)
 *
 * Retour      : booleen
 *
 * Description : renvoi vrai si la balle est situe dans le panier
 *
 */
bool dansPanier(objet panier, Balle balle){
  /* Si les coordonnees de la balle correspondent a l'interieur du panier
     on renvoie vrai sinon on renvoie faux */
  if(balle.x+3>=panier.placement+5 && balle.y-3>=600-panier.hauteur 
     && balle.x-3<=panier.placement+panier.largeur+5){
    return(true);
  }else{
    return(false);
  }
}

/*
 * Fonction    : collision
 *
 * Parametres  : objet panier   (coordonnees du panier)
 *               objet obstacle (coordonnees de l'obstacle)
 *               Balle balle    (coordonnees de la balle)
 *
 * Retour      : vide
 *
 * Description : renvoi vrai si la balle rentre en collision avec un objet
 *
 */
bool collision(objet panier, objet obstacle, Balle balle){
  /* Si la balle touche le sol */
  if(balle.y+3>=600){
    return(true);
  }else{
    /* Si la balle depasse la limite du decor */
    if(balle.x+3>=800){
      return(true);
    }else{
      /* Si la balle touche l'obstacle */
      if(balle.x+3>=obstacle.placement && balle.y+3>=600-obstacle.hauteur 
	 && balle.x-3<=obstacle.placement+obstacle.largeur){
	return(true);
      }else{
	/* Si la balle touche le premier poteau du panier */
	if(balle.x+3>=panier.placement && balle.y+3>=600-panier.hauteur 
	   && balle.x-3<=panier.placement+5){
	  return(true);
	}else{
	  /* Si la balle touche le deuxieme poteau du panier */	
	  if(balle.x+3>=panier.placement+panier.largeur+5 
	     && balle.y+3>=600-panier.hauteur 
	     && balle.x-3<=panier.placement+panier.largeur+10){
	    return(true);
	  }else{
	    return(false);
	  }
	}
      }
    }
  }
}

/*
 * Fonction    : dessineObjet
 *
 * Parametres  : objet panier   (coordonnees du panier)
 *               objet obstacle (coordonnees de l'obstacle)
 *               
 * Retour      : booleen
 *
 * Description : dessine le panier et l'objet sur la fenetre en fonction
 *               des informations de l'obstacle et du panier
 *
 */
void dessineObjet(struct objet obstacle, struct objet panier){
  /* Dessin de l'obstacle */
  modifierCouleur(14);
  remplirRectangle(obstacle.placement,600-obstacle.hauteur,
		   obstacle.placement+obstacle.largeur,600);
  
  /* Dessin des poteaux du panier */
  modifierCouleur(3);
  remplirRectangle(panier.placement,600-panier.hauteur,panier.placement+5,600);
  remplirRectangle(panier.placement+panier.largeur+5,600-panier.hauteur,
		   panier.placement+panier.largeur+10,600);
  
  /* Dessin du contour de l'obstacle et des deux poteaux */
  modifierCouleur(256);
  tracerRectangle(obstacle.placement,600-obstacle.hauteur,
		  obstacle.placement+obstacle.largeur,600);
  tracerRectangle(panier.placement,600-panier.hauteur,panier.placement+5,600);
  tracerRectangle(panier.placement+panier.largeur+5,600-panier.hauteur,
		  panier.placement+panier.largeur+10,600);
}

/*
 * Fonction    : dessineCanon
 *
 * Parametres  : float angle (coordonnees du panier)
 *
 * Retour      : vide
 *
 * Description : dessine le canon sur la fenetre en fonction de l'angle
 *
 */
void dessineCanon(float angle){
  modifierCouleur(1);
  remplirCercle(0,600,150);
  modifierCouleur(256);
  tracerLigne(0,600,(int)(150*cos(angle)),600-(int)(150*sin(angle)));
  modifierCouleur(7);
  remplirCercle(0,600,100);
  modifierCouleur(2);
  remplirCercle(35,565,10);
  modifierCouleur(256);
  tracerCercle(0,600,100);
  tracerCercle(0,600,120);
  tracerCercle(35,565,10); 
}

/*
 * Fonction    : dessineBalle
 *
 * Parametres  : Balle balle (balle a dessiner)
 *               int couleur (couleur de la balle)
 *
 * Retour      : vide
 *
 * Description : dessine la balle en fonction de ses coordonnees et 
 *               de sa couleur
 *
 */
void dessineBalle(Balle balle, int couleur){
  modifierCouleur(couleur);
  remplirCercle(balle.x,balle.y,3);
}

/*
 * Fonction    : dessineJauge
 *
 * Parametres  : int puissance (puissance du tir)
 *
 * Retour      : vide
 *
 * Description : dessine la balle en fonction de ses coordonnees et 
 *               de sa couleur
 *
 */
void dessineJauge(int puissance){
  int posY; // Ordonnee de la souris dans la jauge

  /* Calcul de l'ordonnee de la jauge */
  posY=(int)(-1*((puissance-50)*200)/50.0+250);

  /* Dessin de la jauge */
  modifierCouleur(1);
  remplirRectangle(21,51,50,250);
  modifierCouleur(3);
  remplirRectangle(21,posY,50,250);
  modifierCouleur(256);
  tracerLigne(21,posY,50,posY);
  tracerRectangle(20,50,50,250);
}

/*
 * Fonction    : dessineMenu
 *
 * Parametres  : int tirsReussi (nombre de tirs reussi)
 *               int tirs       (nombre de tirs effectue)
 *
 * Retour      : vide
 *
 * Description : dessine la barre du menu en fonction de la performance 
 *               du joueur
 *
 */
void dessineMenu(int tirsReussi, int tirs){
  float moyenne;          // Pourcentage de tir reussi
  stringstream score(""); // Texte du score du joueur

  /* Calcule de la moyenne */
  if(tirs==0){
    moyenne=0;
  }else{
    moyenne=((float)tirsReussi/tirs)*100;
    moyenne=(ceil(moyenne*100)/100);
  }

  /* Dessin du menu */
  score << "Score : " <<  tirsReussi << " / ";
  score << moyenne << "%";
  modifierCouleur(1);  
  remplirRectangle(0,0,800,30);
  modifierCouleur(256);
  ecrireSurImpression(20,20,"Quitter");
  tracerLigne(0,30,800,30);
  tracerLigne(80,0,80,30);
  tracerLigne(650,0,650,30);
  ecrireSurImpression(670,20,(char*)score.str().c_str()); 
}
