import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import java.io.*;


/**
 * Classe gerant le stockage et l'affichage de toutes les listes manipules.
 * @author Chenevoy.S
 * @author Beuque.E 
 */
public class ListeDeListe extends JComponent implements MouseListener, MouseMotionListener, Serializable{
	private Vector tabListe;
	private Point clic;
	private Liste listSelected;
	public Maillon maillonSelected;
	private ListeCellulesLibres listMaillonLibre;
	/**
	 * Constructeur de ListeDeListe
	 * @param rien
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public ListeDeListe(){
		tabListe=new Vector();
		clic=new Point(20,80);
		listSelected=null;
		maillonSelected=null;
		listMaillonLibre=new ListeCellulesLibres();
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
	}
	/**
	 * Ajout d'une liste passe en paramtre
	 * @param l Liste  ajoute  la liste de liste.
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public void ajouterListe(Liste l){
		l.setCentre(clic);
		tabListe.add(l);
		this.repaint();
	}
	
	/**
	 * Ajout d'un maillon.
	 * Si il n'y a pas de liste selectionn, on revoie une erreur, sinon on ajoute a la liste selection
	 * On verifiera que la liste selectionn n'est pas la liste de cellule qui recupre les maillons retirs.
	 * @param m Maillon  ajouter.
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public void ajouterMaillonListSelected(Maillon m) throws ListeChaineeCreatorError{
		if(!this.hasListSelected()){
			throw new NoListSelectedError("Vous n'avez pas slectionn de liste.");
		}
		if(listSelected==listMaillonLibre){
			throw new ListMaillonLibreSelectedError("Impossible d'ajouter un maillon dans cette liste.");
		}
		listSelected.ajouterMaillon(m);
		this.repaint();
	}
	
	/**
	 * Suppression d'un maillon :
	 * -Si une liste est selectionn, on le retire en tete.
	 * -Si aucune liste n'est selectionn on renvoi une erreur.
	 * -Si un maillon est selection, on le retire.
	 * -On verifiera que la liste selectionn n'est pas la liste de cellule qui recupre les maillons retirs.
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public void retirerMaillonSelected() throws ListeChaineeCreatorError{
        if(listSelected==listMaillonLibre){
            throw new ListMaillonLibreSelectedError("Impossible desupprimer un maillon dans cette liste.");
        }
        if(!this.hasListSelected()){
            throw new NoListSelectedError("Vous n'avez pas slectionnde liste ou de maillon.");
        }
        if(!this.hasMaillonSelected()){
            if(listSelected.getTete()!=null){
                listMaillonLibre.ajouterMaillon(new Maillon(listSelected.getTete().getInfo()));
                listSelected.retirerMaillon();
            }
        }else{
            if(listSelected.getTete()!=null){
                listSelected.retirerMaillon(maillonSelected);
                listMaillonLibre.ajouterMaillon(new Maillon(maillonSelected.getInfo()));
            }
        }
        this.repaint();
    }
	/**
	 * Sauvegarde d'une liste :
	 * -Si aucune liste n'est selectionn on renvoi une erreur, sinon on enregistre celle selctionne
	 * -On verifiera de ne pas enregistrer la liste de cellule qui recupre les maillons retirs.
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public void sauvegarderListeSelected() throws ListeChaineeCreatorError{
		String tmpFichier=null;
		if(listSelected==listMaillonLibre){
			throw new ListMaillonLibreSelectedError("Impossible de sauvergarder cette liste.");
		}
		if(!this.hasListSelected()){
			throw new NoListSelectedError("Vous n'avez pas slectionn de liste.");
		}
		tmpFichier=Interface.choixFichier("Enregistrer");
		if(tmpFichier!=null){
			listSelected.sauvegarder(tmpFichier);
		}
		this.repaint();
	}
	
	
	/**
	 * Reduction d'une liste : 
	 * -Si aucune selectionn, on renvoi une erreur, sinon :
	 * 		-On l'etend, si elle est reduite.
	 * 		-On la reduit si elle est etendue.
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public void reduireEtendreListeSelected() throws ListeChaineeCreatorError{
		if(!this.hasListSelected()){
			throw new NoListSelectedError("Vous n'avez pas slectionn de liste.");
		}
		listSelected.basculeEtendu();
		this.repaint();
	}
	
	/**
	 * Suppression d'une liste : 
	 * -Si aucune selectionn, on renvoi une erreur, sinon on supprime celle selectione.
	 * -On verifiera de ne pas supprimer la liste de cellule qui recupre les maillons retirs.
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public void supprimerListeSelected() throws ListeChaineeCreatorError{
		if(listSelected==listMaillonLibre){
			throw new ListMaillonLibreSelectedError("Impossible de supprimer cette liste.");
		}
		if(!this.hasListSelected()){
			throw new NoListSelectedError("Vous n'avez pas slectionn de liste.");
		}
		while(listSelected.getTete()!=null){
			listMaillonLibre.ajouterMaillon(new Maillon(listSelected.getTete().getInfo()));
			listSelected.retirerMaillon(listSelected.getTete());
		}
		tabListe.remove(listSelected);
		this.repaint();
	}
	/**
	 * Deselectionne un maillon qui a t selectionn.
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public void deselectionneMaillon(){
		if(maillonSelected!=null){
			maillonSelected.setSelected(false);
			maillonSelected=null;
		}
	}
	
	/**
	 * Deselectionne une liste qui a t selectionne.
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public void deselectionneList(){
		if(listSelected!=null){
			listSelected.setSelected(false);
			listSelected=null;
		}
	}
	
	/**
	 * Retourne la premiere liste de la liste de liste.
	 * @return Liste
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public Liste firstElement(){
		return (Liste)tabListe.firstElement();
	}
	
	/**
	 * Retourne la derniere liste de la liste de liste.
	 * @return Liste
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public Liste lastElement(){
		return (Liste)tabListe.lastElement();
	}
	
	/**
	 * Retourne la liste de la liste de liste, situ  la position i.
	 * @return Liste
	 * @param i Position de la liste demande.
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public Liste elementAt(int i){
		return (Liste)tabListe.elementAt(i);
	}
	
	/**
	 * Retourne la liste selectionne de la liste de liste.
	 * @return Liste
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public Liste getListSelected(){
		return listSelected;
	}
	/**
	 * Retourne le maillon selectionn.
	 * @return Maillon
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public Maillon getMaillonSelected(){
		return maillonSelected;
	}
	
	/**
	 * Retourne la liste de type listCellulesLibre.
	 * @return Liste
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public Liste getListMaillonLibre(){
		return listMaillonLibre;
	}
	
	/**
	 * Retourne vrai si une liste est selectionne, sinon faux.
	 * @return boolean
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public boolean hasListSelected(){
		if(listSelected==null){
			return false;
		}else{
			return true;
		}
	}
	
	/**
	 * Retourne vrai si un maillon est selectionn, sinon faux.
	 * @return boolean
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public boolean hasMaillonSelected(){
		if(maillonSelected==null){
			return false;
		}else{
			return true;
		}
	}
	
	/**
	 * Retourne le nombre de liste situe dans la liste de liste.
	 * @return entier
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public int nbList(){
		return tabListe.size();
	}
	
	/**
	 * L'apparition d'un evenement de type MouseEvent (ici les evenements lis au clique souris sur la surface de dessin) entraine :
	 * -Selection/Deselection de listes/maillons...
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @param e Prend la valeur d'un evenement de type MouseEvent qui survient.
	 * @return rien
	 */
	public void mouseClicked(MouseEvent e){
		int i=0;
    	clic=e.getPoint();
    	this.deselectionneMaillon();
    	this.deselectionneList();
    	this.ajusteDimension();
    	
    	if(listMaillonLibre.isPointSurTeteListe(clic)){
			listSelected=listMaillonLibre;
			listSelected.setSelected(true);
		}else{
			if(maillonSelected==null){
				maillonSelected=listMaillonLibre.renvoiMaillonSousPoint(clic);
				if(maillonSelected!=null){
					maillonSelected.setSelected(true);
					listSelected=listMaillonLibre;
				}
			}
		}
    	if(listSelected==null && maillonSelected==null){
    		for(i=0;i<this.nbList();i++){
    			if(this.elementAt(i).isPointSurTeteListe(clic)){
    				listSelected=this.elementAt(i);
    				listSelected.setSelected(true);
    			}else{
    				if(maillonSelected==null){
    					maillonSelected=this.elementAt(i).renvoiMaillonSousPoint(clic);
    					if(maillonSelected!=null){
    						maillonSelected.setSelected(true);
    						listSelected=this.elementAt(i);
    					}
    				}
    			}
    		}
    	}
		this.repaint();
    }
    public void mousePressed(MouseEvent e){ }
    public void mouseReleased(MouseEvent e){ }
    public void mouseEntered(MouseEvent e){ }
    public void mouseExited(MouseEvent e){ }
    /* Mthodes implmente dans l'interface MouseMotionListener */
    public void mouseDragged(MouseEvent e){
    	if(this.hasListSelected()){
    		//listSelected.setCentre(e.getPoint());
    	}
    }
    public void mouseMoved(MouseEvent e){ }


    /**
	 * Dessin de la liste de liste, grace a l'appel de la methode paint() de chaque liste.
	 * Dessin de la liste de type listeCelluleLibre.
	 * Dessin du plot si necessaire.
	 * @param g Graphique correspondant a l'affichage des listes.
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
    public void paintComponent(Graphics g){
    	int i=0;
	    
    	for(i=0;i<tabListe.size();i++){
    		this.elementAt(i).paint(g);
    	}
    	listMaillonLibre.setCentre(new Point(20,20));
    	listMaillonLibre.paint(g);
    	if(!this.hasListSelected() && !this.hasMaillonSelected()){
    		g.drawLine(clic.x-2,clic.y,clic.x+2,clic.y);
    		g.drawLine(clic.x,clic.y-2,clic.x,clic.y+2);
    	}
    }
    
    /**
	 * Ajuste les dimensions du Jcomponent dont cette classe est hrite.
	 * Ceci est necessaire au bon fonctionnement des ascenseurs.
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
    public void ajusteDimension(){
    	Dimension dimension=new Dimension(400,400);
    	int i;
    	for(i=0;i<this.nbList();i++){
    		if(dimension.width<this.elementAt(i).occupeSurface().width+this.elementAt(i).occupeSurface().x){
    			dimension.width=this.elementAt(i).occupeSurface().width+this.elementAt(i).occupeSurface().x+200;
    		}
    		if(dimension.height<this.elementAt(i).occupeSurface().height+this.elementAt(i).occupeSurface().y){
    			dimension.height=this.elementAt(i).occupeSurface().height+this.elementAt(i).occupeSurface().y+200;
    		}
    	}
    	this.setPreferredSize(dimension);
    	this.setSize(dimension);
    	this.setMinimumSize(dimension);
    	this.setMaximumSize(dimension);
    }
    
    /**
	 * Sauvegarde l'objet listeDeListe dans un fichier.
	 * @param cheminFichier Chemin+nom du fichier de sauvegarde situ sur le disque dur.
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public void sauvegarder(String cheminFichier){
		
			try{
				FileOutputStream fichier = new FileOutputStream(cheminFichier);
				ObjectOutputStream oos = new ObjectOutputStream(fichier);
				oos.writeObject(this);
				oos.flush();
				oos.close();
			}
			catch(java.io.IOException e) {
				e.printStackTrace();
			}
	}
	
	/**
	 * Ouvre l'objet listeDeListe situ dans un fichier.
	 * @param cheminFichier Chemin+nom du fichier  ouvrir situ sur le disque dur.
	 * @return ListeDeListe
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public static ListeDeListe ouvrir(String cheminFichier){
		ListeDeListe vectorListe=null;
		
		try{
			FileInputStream fichier = new FileInputStream(cheminFichier);
			ObjectInputStream fluxListeDeListe;
			try{
				fluxListeDeListe = new ObjectInputStream(fichier);
				vectorListe=(ListeDeListe) fluxListeDeListe.readObject();
			}catch(ClassNotFoundException e){}
		}catch(IOException e){}
		
		return vectorListe;
	
	}
}
